DROP PROCEDURE [hips].[CountryCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the Country Code Table
-- =============================================
CREATE PROCEDURE [hips].[CountryCodeGet] 
(
	@CodeSystemCode VARCHAR,
	@CountryId INT = NULL
)
AS
BEGIN

	SELECT  c.CountryId, c.Code, c.Description
	FROM    hips.CountryCode cc
			JOIN hips.Country c ON cc.CountryId = c.CountryId
			JOIN hips.CodeSystem cs ON cc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND c.CountryId = @CountryId OR @CountryId IS NULL
	ORDER BY c.Description

END
GO

